﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Activity.master" AutoEventWireup="true" CodeBehind="ActivityPreprocesses.aspx.cs" Inherits="GUI.Pages.ActivityPreprocesses" %>
<%@ Register Src="~/Controls/ActivityNavigation.ascx" TagName="ActivityNavigation" TagPrefix="uc" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
	<uc:ActivityNavigation ID="ActivityNavigation" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
	<div class="main-form-box">
        
			<h2><asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Activity_Preproceses %>" /></h2>
			<%--<telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1">--%>
            <div class="form-wrapper">
				<asp:HiddenField ID="hdnProjectId" runat="server" />
				<asp:HiddenField ID="hdnPreprocessId" runat="server" Value="0" />
				<div class="row">
					<div class="five columns">
						<div class="formField">
							<label><asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Task_ChooseActivity %>" /></label>
							<script type="text/javascript">
							function requesting(sender, eventArgs) {
									var context = eventArgs.get_context();
									//Data passed to the service.
									context["ProjectId"] = $('#<%= hdnProjectId.ClientID %>').val();
									context["AvoidActivityId"] = '<%= Request.QueryString["aid"] %>';
								}

								function OnClientEntryAddingHandler(sender, eventArgs) {

									if (sender.get_entries().get_count() == 1) {
										eventArgs.set_cancel(true);
										//alert("You can select only one entry");
									}

								}
							</script>
							<telerik:RadAutoCompleteBox ID="radActivityAutocomplete" runat="server" Width="100%" DropDownHeight="150"   DropDownWidth="250" OnClientEntryAdding="OnClientEntryAddingHandler" OnClientRequesting="requesting">
								<WebServiceSettings Method="GetActivitiesAsReferingForPreprocess" Path="~/WebService/LoadEntities.asmx" />
							</telerik:RadAutoCompleteBox>
							<asp:RequiredFieldValidator ID="radActivityAutocompleteRequired" runat="server"  Display="Dynamic" SetFocusOnError="true" CssClass="vError"
												ControlToValidate="radActivityAutocomplete" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
												ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator>
						</div>
					</div>
					<div class="four columns">
						<div class="formField">
							<label><asp:Literal ID="Literal6" runat="server" Text="<%$ Resources:ProjectManagementUI, Activity_PreprocesType %>" /></label>
							<telerik:RadComboBox ID="ddlPreprocess" runat="server" EmptyMessage="Izaberite" RenderingMode="Simple" Width="100%">
							</telerik:RadComboBox>
									
							<asp:RequiredFieldValidator ID="ddlPreprocessRequired" runat="server"  Display="Dynamic" SetFocusOnError="true" CssClass="vError"
												ControlToValidate="ddlPreprocess" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" InitialValue="Izaberi"
												ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator>
						</div>
					</div>
					<div class="three columns">
						<div class="formField">
                            <label><asp:Literal ID="Literal7" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Days %>" /></label>
                            <telerik:RadNumericTextBox Type="Number" Font-Bold="True" runat="server" ID="txtNumberOfDays" Width="100%" NumberFormat-DecimalDigits="0"  />
							<asp:RequiredFieldValidator ID="RequiredtxtNumberOfDays" runat="server"  Display="Dynamic" SetFocusOnError="true" CssClass="vError"
														ControlToValidate="txtNumberOfDays" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" InitialValue=""
														ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator>
                        </div>
					</div>
					<div class="clear"></div>
				</div>
				<div class="row">
					<div class="twelve columns">
						<div class="buttonBar">
							<asp:Button ID="btnSave" CssClass="button orange" OnClick="BtnSaveClick" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
								runat="server" />
							<asp:Button ID="btnNew" CssClass="button " OnClick="BtnNewClick" Text="<%$ Resources:ProjectManagementUI, Common_New %>" runat="server" />
						</div>
					</div>
				</div>

				<div class="wide-box">
		
					<div class="content-wrapper">
						<telerik:RadGrid ID="grdPreprocesses" runat="server" PageSize="10" AllowFilteringByColumn="true" 
											AllowPaging="true" AllowSorting="true" OnNeedDataSource="grdPreprocesses_OnNeedDataSource" ClientSettings-ClientEvents-OnCommand="scrollOnEdit"
											OnItemCommand="grdPreprocesses_ItemCommand" Skin="Bootstrap">
							<PagerStyle Mode="NextPrevAndNumeric" />
				
							<MasterTableView ShowHeadersWhenNoRecords="true" TableLayout="Auto" ShowFooter="False" AutoGenerateColumns="False" DataKeyNames="Id">
								<Columns>
								<%--<telerik:GridHyperLinkColumn NavigateUrl=""--%>
									<telerik:GridBoundColumn UniqueName="PreprocessTypeColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="EnumPreprocessType.NameLocalized" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Activity_PreprocesType %>" DataField="EnumPreprocessType.NameLocalized" />
									<telerik:GridBoundColumn UniqueName="ReferingActivityColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="ReferingActivity.Name" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Activity_PreprocesName %>" DataField="ReferingActivity.Name" />
									<telerik:GridButtonColumn CommandName="Select" UniqueName="SelectColumn" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Edit %>" ButtonCssClass="edit" />
									<telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderText="" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ButtonCssClass="delete" />
								</Columns>
							</MasterTableView>	

						</telerik:RadGrid>
					</div>
				</div>

			</div>
			<%--</telerik:RadAjaxPanel>--%>
	</div>
	<%--<telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1"  >
        <div class="updatePanelProgress"><asp:Literal ID="ltrPLeaseWait" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
    </telerik:RadAjaxLoadingPanel>--%>
</asp:Content>
